// pnPlugin.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include <stdlib.h>
#include <stdio.h>
#include "resource.h"
#include "pnPlugin.h"

static int selectedMode = 0;
static unsigned char R[256],G[256],B[256];
static char szPath[255];
static char szExePath[255];

plInfo Info = 
	{"0.4.0",
	"contraste",
	"fausses couleurs",
	"application d'une LUT sur image de luminance"
	};

char * fLUT0="\\plugins\\LUT_spectrum.txt";
char * fLUT1="\\plugins\\LUT_fire.txt";
char * fLUT2="\\plugins\\LUT_jet.txt";
char * fLUT3="\\plugins\\LUT_autumn.txt";
char * fLUT4="\\plugins\\LUT_copper.txt";


initLUT(){
	for (int i=0;i<256;i++){
		R[i]=(unsigned char) i;
		G[i]=(unsigned char) i;
		B[i]=(unsigned char) i;
	}
	return 0;
}
readLUT(int mode){
	 char s[80];
	 char szTmp[256];
	 char *fLUT;
	 FILE * f;
	 int iL,v1,v2,v3;
	 int i;

	switch (mode){
		case 0:	fLUT=fLUT0;	break;
		case 1:	fLUT=fLUT1;	break;
		case 2:	fLUT=fLUT2;	break;
		case 3:	fLUT=fLUT3;	break;
		case 4:	fLUT=fLUT4;	break;
		default: fLUT=fLUT0;break;
	}
	strcpy(szTmp,szExePath);
	strcat(szTmp,fLUT);
	try{
	//f= fopen (fLUT,"r");
	f= fopen (szTmp,"r");
	fscanf(f,"%s%s%s%s\n",s,s,s,s);
	for (i=0;i<256;i++){
	//while (!EOF){
		fscanf(f,"%i%i%i%i\n",&iL,&v1,&v2,&v3);
		R[iL]=(unsigned char) v1;
		G[iL]=(unsigned char) v2;
		B[iL]=(unsigned char) v3;
	}
	}
	catch (...)
	{
		initLUT();
		selectedMode = 0;
	}
	if (f) fclose(f);
	return 0;
}

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	char strMode[80];
	char *c;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
			c=szPath+GetModuleFileName(0,szPath,255);
			while (*c != '\\') c--;
				*c =0;
			strcpy(szExePath,szPath);
			strcat(szPath,"\\PortaNum.ini");
			GetPrivateProfileString("pluginFaussesCouleurs","LUT","0",strMode,80,szPath);
			selectedMode =atoi(strMode);
			readLUT(selectedMode);
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			itoa(selectedMode,strMode,10);
			WritePrivateProfileString("pluginFaussesCouleurs","LUT",strMode,szPath);
			break;
    }
    return TRUE;
}


PNPLUGIN_API const char* PnPluginAppName( void )
{
    //version;
    const char * appName;
    appName = "PortaNum";
    return appName;
}

PNPLUGIN_API int PnPluginInfo(plInfo * pInfo )
{
	if (pInfo) 
	{*pInfo = Info;
    return 0;
	}
	else return 1;
}

BOOL CALLBACK AboutDlgProc(HWND hDlg, UINT message,WPARAM wParam,LPARAM lParam)
{
	int radioSel;
	switch (message)
	{
	case WM_INITDIALOG :
		//if (selectedMode == 0) radioSel = IDC_RADIO1;
		//    else radioSel = IDC_RADIO2;
		switch (selectedMode)
			{
			case 0: radioSel = IDC_RADIO1; break;
			case 1: radioSel = IDC_RADIO2; break;
			case 2: radioSel = IDC_RADIO3; break;
			case 3: radioSel = IDC_RADIO4; break;
			case 4: radioSel = IDC_RADIO5; break;
			}
		CheckRadioButton(hDlg, IDC_RADIO1, IDC_RADIO5, radioSel);
		return true;
	case WM_COMMAND:
		switch (LOWORD (wParam))
			{
			case IDC_RADIO1:
				selectedMode = 0;
				readLUT(selectedMode);
			break;
			case IDC_RADIO2:
				selectedMode = 1;
				readLUT(selectedMode);
			break;
			case IDC_RADIO3:
				selectedMode = 2;
				readLUT(selectedMode);
			break;
			case IDC_RADIO4:
				selectedMode = 3;
				readLUT(selectedMode);
			break;
			case IDC_RADIO5:
				selectedMode = 4;
				readLUT(selectedMode);
			break;
			case IDOK:
			case IDCANCEL:
				EndDialog(hDlg,0);
				return true;
			}
			break;
		}
		return FALSE;
}

PNPLUGIN_API IppStatus PnPluginDialog(HINSTANCE hInstance, HWND hwnd)
{	char buffer[128];
	LPSTR lpstrPrompt = &buffer[0];
	int res = DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOG1),hwnd, AboutDlgProc);
	if (res == -1 ) { 
		sprintf(lpstrPrompt,"erreur : %d",GetLastError());
		MessageBox(NULL,lpstrPrompt,"",NULL);
		return 1; // pas de page de config
	}
	return 0; // ok
}


PNPLUGIN_API IppStatus PnPluginFunction( Ipp8u* pSrc, int srcStep, Ipp8u* pDst, int dstStep, IppiSize roiSize, int mode, int coef )
{
    IppStatus status = 0;  // 0 = no error
	Ipp8u * pS = pSrc;
	Ipp8u * pD = pDst;
	int iy, ix;
	int y;
	unsigned char cy;
	int ymax = 255*256;


	// function implementation ...
		for (iy=0; iy<roiSize.height; iy++)
		{  for (ix=0; ix<(roiSize.width * 3); ix=ix+3) {
				// valeur nominale de coef: 50
				y=coef*(pS[ix]+2*pS[ix+1]+pS[ix+2]);
				if (y>ymax) y=ymax;
				cy = (unsigned char) (y>>8);
                pD[ix] = (Ipp8u) B[cy];
				pD[ix+1] = (Ipp8u) G[cy];
				pD[ix+2] = (Ipp8u) R[cy];
                }
        pS=pS+srcStep;
		pD=pD+srcStep;
        }

    return status;
}

